require( "quest/m3_flowershop/convout.lua" );
combine_speech_tables();

max_flowers = 6;

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

function flo_conv(flo, marco)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("tulip_found_in_flower_shop") < max_flowers or game:Get("tulip_found_in_flower_shop") < max_flowers then
		run_super_conversation(flo, "quip_flowers_floA");
	elseif game:Get("mg_flower_activity_round") < 2 then
		run_super_conversation(flo, "quip_flowers_floB");
	else
		run_super_conversation(flo, "quip_flowers_floC");
	end;
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		actor:SetMode(MODE.CUTSCENE);
		local lastScene = game:GetLastScene();
		
		if lastScene == "mg_flower" then
			coroutine.yield(RESUME.NOW);
			actor:JumpToNamedPoint("flo");
			actor:FaceNow(DIR.W);
			wait_fade();
			
			if game:Get("mg_flower_activity_round") >= 2 then
				run_super_conversation(actor, "conv_marco_done");
				game:Set( "bouquets_delivered", 1 );
				complete_quest("flowers", false);
				game:EarnAward("avenue-flo_bouquets");
				complete_quest("arrange_bouquets", false);
				add_quest("find_bernie");
				wait_subscene();
				
				actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);	
				actor:WalkTo("exit_walkto");
				wait_walkto();
				
				scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
				scene:SetFadeSpeed(0.05);
				scene:SetMusicVolumeSpeed(0.05);
				wait_fade();
				
				sfx:SetMusic("audio/music/music_delivery_movies.ogg", true);
				scene:DisplayFlash("flash/deliverycut_scene_flowers_intro.swf");
				wait_subscene();
				
				scene:ChainTo("m3_big");
			else
				run_super_conversation(actor, "quip_flowers_not_done");
				actor:SetMode(MODE.FOLLOWCLICKS);
			end
		else
			actor:JumpToNamedPoint("exit_walkto");
			actor:FaceNow(DIR.W);
			actor:WalkTo("flo");
			wait_walkto();
			
			actor:Face(DIR.NW);

			if game:Get("first_time_flowershop") < 1 then		
				game:Set("first_time_flowershop", 1);
				run_super_conversation(actor, "conv_marco_intro");
				complete_quest("check_with_marco", false);
				add_quest("find_flowers")
				wait_subscene();
				actor:SetMode(MODE.FOLLOWCLICKS);
			else
				actor:SetMode(MODE.FOLLOWCLICKS);
			end
		end
	end;
	
	on_arrive = function(flo, marco)
		flo:StartProc(flo_conv);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function setup_container_flowers(flower_type)
	local container_flower = get_container_flower_spec(flower_type);
	local flowers_found = game:Get(flower_type .. "_found_in_flower_shop");
	
	if flowers_found > 0 then
		container_flower:LoadImage("container_" .. flower_type .. "0" .. flowers_found);
	end
end;

function get_container_flower_spec(_type)
	return scene:Spawn
	{
		name = "CONTAINER_FLOWER_" .. string.upper(_type);
		
		command = function(actor)
			actor:SetDepthValue(10);
		end;
	}
end;

function create_container_flower(flo, flower)
	flo:StartProc(
		function(flo)
			flo:SetMode(MODE.CUTSCENE);
			
			sfx:PlaySFX("audio/sfx/flower_found");
			
			if flower.flowertype == "tulip" then
				--send the flower to the rest position
				flower:WalkTo("tulips_rest");
				wait_walkto(flower);
				--delay(30);
				
				--update container_tulip
				scene.CONTAINER_FLOWER_TULIP:LoadImage("container_tulip0" .. game:Get("tulip_found_in_flower_shop"));
					
				if game:Get("tulip_found_in_flower_shop") == max_flowers then
					if game:Get("rose_found_in_flower_shop") == max_flowers then
						flo:StartProc(marco_conv_all	);		
					else
						flo:StartProc(marco_conv_tulip);												 
					end
				end;
				
				--expire flower
				--delay(5);
				flower:Expire();
			else
				--send the flower to the rest position
				flower:WalkTo("roses_rest");
				wait_walkto(flower);
				--delay(30);
				
				--update container_rose
					scene.CONTAINER_FLOWER_ROSE:LoadImage("container_rose0" .. game:Get("rose_found_in_flower_shop"));
				
				--calculate offset
				if game:Get("rose_found_in_flower_shop") == max_flowers then
					if game:Get("tulip_found_in_flower_shop") == max_flowers then	
						flo:StartProc(marco_conv_all);	
					else
						flo:StartProc(marco_conv_rose);	
					end
				end;
				
				--expire flower
				--delay(5);
				flower:Expire();
			end;
			
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	);
end

function get_flower_spec(_name, _depth, _flowertype, _meshtype)
	return
	{
		name = _name;
		halo = "flower";
		gfx = { image = _meshtype };
	
		
		command = function(actor)
			actor.value = _name;
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
			actor.flowertype = _flowertype;
			actor:SetDepthValue(_depth);
			
			actor:JumpToNamedPoint(_name);
			
			actor:SetWalkSpeed(15);
		end;
		
		on_click = function(flo, flower)
			game:Set("flower_shop_" .. flower.value, 1);
			local flower_found = game:Get(_flowertype .. "_found_in_flower_shop");
			flower_found = flower_found + 1;
			game:Set(_flowertype .. "_found_in_flower_shop", flower_found);
			flower:SetDepthMode(DEPTH.DEPTH_FIXED);
			flower:SetDepthValue(700);
			
			
			create_container_flower(flo, flower);
						
			if game:Get("tulip_found_in_flower_shop") >= max_flowers and game:Get("rose_found_in_flower_shop") >= max_flowers then
				game:Set("collected_flowers", 1);				
			elseif flower_found == max_flowers then
				flo:StartProc(marco_conv_type);
			end;			
			
			return RESPONSE.IGNORE;
		end;
	}
end;

function marco_conv_all(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_marco_ready");
	complete_quest("find_flowers", false);
	add_quest("arrange_bouquets");
	wait_subscene();
	goto_scene(flo, "mg_flower", true);
end

function marco_conv_tulip(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_tulip");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function marco_conv_rose(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_rose");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

tulip_table =
{
	{"purple_tulip01", 9000, "tulip", "purple_tulip01"},
	{"purple_tulip02", 9000, "tulip", "purple_tulip02"},
	{"purple_tulip03", 9000, "tulip", "purple_tulip03"},
	{"purple_tulip04", 9000, "tulip", "purple_tulip04"},
	{"purple_tulip05", 9000, "tulip", "purple_tulip05"},
	{"purple_tulip06", 9000, "tulip", "purple_tulip06"},
};

rose_table =
{
	{"red_rose01", 9000, "rose", "red_rose01"},
	{"red_rose02", 9000, "rose", "red_rose02"},
	{"red_rose03", 9000, "rose", "red_rose03"},
	{"red_rose04", 9000, "rose", "red_rose04"},
	{"red_rose05", 9000, "rose", "red_rose05"},
	{"red_rose06", 9000, "rose", "red_rose06"},
};

function spawnFlowers(Table)
	for i = 1, max_flowers, 1 do
		if game:Get("flower_shop_" .. Table[i][1]) < 1 then
			scene:Spawn(get_flower_spec(Table[i][1], Table[i][2], Table[i][3], Table[i][4]));
		end
	end;
end

function get_bouqet_spec(_name)
	return
	{
		name = _name;
		gfx = { image = _name };
		
		command = function(actor)
			actor:SetDepthValue(220);
		end;
	}
end;

function spawnBouqets()
	if game:Get("mg_flower_activity_round") < 2 then
		for i = 1, game:Get("mg_flower_activity_num")-1, 1 do
			scene:Spawn(get_bouqet_spec("bouquet" .. i));
		end;
	elseif game:Get("bouquets_delivered") ~= 1 then 
		for i = 1, 8, 1 do
			scene:Spawn(get_bouqet_spec("bouquet" .. i));
		end;
	end;
end

function marco_conv(flo, marco)

	if game:Get("tulip_found_in_flower_shop") < max_flowers or game:Get("tulip_found_in_flower_shop") < max_flowers then
		run_super_conversation(flo, "conv_marcoA");
	elseif game:Get("mg_flower_activity_round") < 2 then
		run_super_conversation(flo, "conv_marcoB");
	else
		run_super_conversation(flo, "conv_marcoC");
	end;

end;

marco_spec = 
{
	name = "MARCO";
	halo = "quest/objects/cassiew";
	
	command = function(actor)
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		if game:Get("mg_flower_activity_round") < 2 then
			actor:JumpToNamedPoint("marco1");
			actor:LoadAnimFile("anim/marco/stand");
			actor:LoadAnimFile("anim/marco/talke");
			actor:SetDepthValue(427);
		else
			actor:JumpToNamedPoint("marco2");
			actor:LoadAnimFile("anim/marco/stand2");
			actor:LoadAnimFile("anim/marco/talk2e");
			actor:SetDepthValue(370);
		end
		prepare_actor_text(actor, marco_text_spec);
		actor:FaceNow(DIR.E);
		actor:PlayAnim("DoStandE");
	end;
	
	on_arrive = function(flo, marco)
		flo:FaceActor(marco);
		if game:Get("tulip_found_in_flower_shop") < max_flowers or game:Get("tulip_found_in_flower_shop") < max_flowers then
			convproc("FLO", "conv_marcoA");
		elseif ( game:Get( "bouquets_delivered" ) ~= 1 ) then
			convproc("FLO", "conv_marcoB");
		elseif ( game:Get( "suspicious_done" ) == 1 ) then
			if ( game:Get( "found_bernie" ) ~= 1 ) then
				convproc("FLO", "conv_marcoC");
			else
				convproc("FLO", "conv_marcoD");
			end
		else
			convproc("FLO", "conv_marcoD");
		end
	end;	
};

function lookat_workbench(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("collected_flowers") >= 1 and game:Get("mg_flower_activity_round") < 2 then
		if game:Get("first_time_flower_activity") < 1 then
			run_super_conversation(flo, "conv_marco_warning");
		else
			run_super_conversation(flo, "quip_workbenchB");
		end;
		goto_scene(flo, "mg_flower", true);
	elseif ( game:Get( "bouquets_delivered" ) ~= 1 ) then
		run_super_conversation(flo, "quip_workbenchA");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		run_super_conversation(flo, "quip_workbenchC");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end;
end

workbench_spec =
{
	name = "workbench";
	halo = "workbench";
	
	on_arrive = function(flo, actor)
		flo:StartProc(lookat_workbench);
	end;
};

function gotobig(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);	
	flo:WalkTo("exit_walkto");
	wait_walkto();
	goto_scene(flo, "m3_big");
end;

exit_spec = 
{
	name = "EXIT";
	halo = "exit";
	depth = 1;
	cursor = "cursor_arrow_e";
	goto_fn = gotobig;
};

table_spec = 
{
	name = "table";
	halo = "table";
	gfx = { image = "round_table" };
	
	command = function(actor)
		actor:SetDepthValue(380);
	end;
	
	on_arrive = function(flo, actor)
		if math.random(2) == 1 then
			convproc("FLO", "quip_tableA");
		else
			convproc("FLO", "quip_tableB");
		end;
	end;
};

balloons_spec = 
{
	name = "balloons";
	halo = "balloons";
	gfx = { image = "balloons" };
	
	command = function(actor)
		actor:SetDepthValue(1);
	end;
	
	on_arrive = function(flo, actor)
		if math.random(2) == 1 then
			convproc("FLO", "quip_balloonsA");
		else
			convproc("FLO", "quip_balloonsB");
		end;
	end;
};

flower_display_spec = 
{
	name = "flower_display";
	halo = "flower_display";
	gfx = { image = "flower_display" };
	
	command = function(actor)
		actor:SetDepthValue(580);
	end;
	
	on_arrive = function(flo, actor)
		if game:Get("tulip_found_in_flower_shop") < max_flowers or game:Get("tulip_found_in_flower_shop") < max_flowers then
			convproc("FLO", "quip_flower_displayA");
		else
			convproc("FLO", "quip_flower_displayB");
		end;
	end;
};

posters_spec = 
{
	name = "posters";
	halo = "posters";
	gfx = { image = "posters" };
	
	command = function(actor)
		actor:SetDepthValue(2);
	end;
	
	on_arrive = function(flo, actor)
		convproc("FLO", "quip_postersA");
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/beautysalonmusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
		end
		
		spawnFlowers(tulip_table);
		spawnFlowers(rose_table);
		spawnBouqets();
		--scene:Spawn( get_flower_spec("container_tulip", 9,
		--							 "container_tulip") );
		
		spawn_nav_arrow(exit_spec);
		
		setup_container_flowers("tulip");
		setup_container_flowers("rose");
		
		game:SetString("map_position", "m3_flower");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "flower_pot", 10 },
		
		{ "bouquet_rack", 200 },
		
		{ "basket1", 470 },
		{ "basket2", 500 },
		{ "basket3", 450 },
		{ "conch_shell", 460 },
		{ "front_table", 485 },
		{ "front_table_items", 487 },
		{ "sink", 345 },
		{ "spinner_rack", 250 },
		{ "spray_bottle", 495 },
		{ "table_lamp", 455 },
		{ "vase1", 490 },
		{ "vase2", 480 },
		
		{ "flower_table", 500 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		
		scene_setup,
		workbench_spec,
		marco_spec,
		
		table_spec,
		balloons_spec,
		flower_display_spec,
		posters_spec,
	};
};